<?php


class smartJunction4{
	public $data;
	public $mysqli;
	
	public function __construct($data){
		$this->data=$data;
		$this->mysqli=new mysqli($this->data["host"], $this->data["username"], $this->data["password"], $this->data["database"]);
		$this->set("SET NAMES utf8");
		$this->set("SET CHARACTER SET utf8");
		$this->mysqli->set_charset("utf8");
	}
	
	public function table($tableName){
		return new smartJunction3_Table($this,$tableName);
	}
	public function getInsertId(){
		return $this->mysqli->insert_id;
	}
	public function insertID(){
		return $this->mysqli->insert_id;
	}
	public function insert_id(){
		return $this->mysqli->insert_id;
	}
	
	public function getrow(){
		$sql=func_get_arg(0);
		if(strpos($sql,"SELECT")===0){
			if(strpos($sql," LIMIT ")===false && strpos($sql," FOR UPDATE")===false) $sql.=" LIMIT 1";
		}
		if(func_num_args()==1)$dataArray=array();
		else $dataArray=func_get_arg(1);
		
		if(gettype($dataArray)!=='array') $dataArray=[$dataArray];
			
		$stmt = $this->mysqli->prepare($sql);
		if(count($dataArray)>0){
			$typeString="";
			for($i=0;$i<count($dataArray);$i++){
				if(gettype($dataArray[$i])=="integer") $typeString.='i';
				else if(gettype($dataArray[$i])=="double") $typeString.='d';
				else $typeString.='s';
			}
			array_unshift($dataArray,$typeString);
			call_user_func_array(array($stmt, 'bind_param'), $this->refValues($dataArray));
		}
		$stmt->execute();
		$res = $stmt->get_result();
		$row=null;
		if($res->num_rows>=1){
			$row = $res->fetch_array(MYSQLI_ASSOC);
		}
		$stmt->close();
		return $row;
	}
	public function getlist(){
		$sql=func_get_arg(0);
		if(func_num_args()==1)$dataArray=array();
		else $dataArray=func_get_arg(1);
		
		if(gettype($dataArray)!=='array') $dataArray=[$dataArray];
			
		$stmt = $this->mysqli->prepare($sql);
		if(count($dataArray)>0){
			$typeString="";
			for($i=0;$i<count($dataArray);$i++){
				if(gettype($dataArray[$i])=="integer") $typeString.='i';
				else if(gettype($dataArray[$i])=="double") $typeString.='d';
				else $typeString.='s';
			}
			array_unshift($dataArray,$typeString);
			call_user_func_array(array($stmt, 'bind_param'), $this->refValues($dataArray));
		}
		$stmt->execute();
		$res = $stmt->get_result();
		$rows=array();
		while($row = $res->fetch_array(MYSQLI_ASSOC)) {
			array_push($rows, $row);
		}
		return $rows;
	}
	public function set(){
		$sql=func_get_arg(0);
		if(func_num_args()==1)$dataArray=array();
		else $dataArray=func_get_arg(1);
		
		if(gettype($dataArray)!=='array') $dataArray=[$dataArray];
		
		$stmt = $this->mysqli->prepare($sql);
		//echo $sql.'<br/>';
		if(count($dataArray)>0){
			$typeString="";
			for($i=0;$i<count($dataArray);$i++){
				if(gettype($dataArray[$i])=="integer") $typeString.='i';
				else if(gettype($dataArray[$i])=="double") $typeString.='d';
				else $typeString.='s';
			}
			array_unshift($dataArray,$typeString);
			call_user_func_array(array($stmt, 'bind_param'), $this->refValues($dataArray));
		}
		$returnValue=$stmt->execute();
		$stmt->close();
		return $returnValue;
	}
	public function query(){
		$sql=func_get_arg(0);
		$this->mysqli->query($sql);
	}
	function refValues($arr){
		if (strnatcmp(phpversion(),'5.3') >= 0) //Reference is required for PHP 5.3+
		{
			$refs = array();
			foreach($arr as $key => $value)
				$refs[$key] = &$arr[$key];
			return $refs;
		}
		return $arr;
	}
	
	function generateTablesFromJSON($jsonString){
		$json=json_decode($jsonString,true);
		foreach($json["table"] as $table){
			
			//format json column type
			$count=0;
			foreach($table["column"] as $column){
				$column['type']=strtoupper($column['type']);
				if(strpos($column['type'],'INT')!==FALSE){
					if(strpos($column['type'],'(')!==FALSE){
						$column['type']=substr($column['type'],0,strpos($column['type'],'('));
					}
				}
				$table["column"][$count]=$column;
				$count++;
			}
			//end
			
			$row=$this->getRow("SHOW TABLES LIKE '$table[name]'");
			if($row==null){//create table columns
				$this->set("CREATE TABLE `$table[name]` (id BIGINT PRIMARY KEY auto_increment)ENGINE=InnoDB CHARSET=utf8 COLLATE utf8_bin");
				foreach($table["column"] as $column){
					$this->set("ALTER TABLE `$table[name]` ADD `$column[name]` $column[type]");
				}
			}else{//alter table columns
				
				$description=$this->getArray("DESCRIBE `$table[name]`");
				
				//format mysql column type
				$count=0;
				foreach($description as $columnInfo){
					$columnInfo['Type']=strtoupper($columnInfo['Type']);
					if(strpos($columnInfo['Type'],'INT')!==FALSE){
						if(strpos($columnInfo['Type'],'(')!==FALSE){
							$columnInfo['Type']=substr($columnInfo['Type'],0,strpos($columnInfo['Type'],'('));
						}
					}
					$description[$count]=$columnInfo;
					$count++;
				}
				//end
				
				foreach($table["column"] as $column){
					$columnExists=false;
					foreach($description as $columnInfo){
						if($columnInfo['Field']==$column['name']){
							if($columnInfo['Type']!=$column['type']){
								$this->set("ALTER TABLE `$table[name]` MODIFY `$column[name]` $column[type];");
							}
							$columnExists=true;
							break;
						}
					}
					if(!$columnExists){
						$this->set("ALTER TABLE `$table[name]` ADD `$column[name]` $column[type]");
					}
				}
			}
			
			if(isset($table["index"])){
				foreach($table["index"] as $index){
					$row=$this->getRow("SHOW INDEX FROM `$table[name]` WHERE Key_name='$index[name]'");
					if($row==null){
						$index['type']=strtoupper($index['type']);
						$columnNameArray=array();
						foreach($index['column'] AS $columnName){
							array_push($columnNameArray,'`'.$columnName.'`');
						}
						$columnNameArrayImploded=implode(',',$columnNameArray);
						$this->set("ALTER TABLE `$table[name]` ADD $index[type] `$index[name]` ($columnNameArrayImploded)");
						
					}
				}
			}
			
		}
	}
	
	
}
class smartJunction3_Table{
	public $smartJunction3;
	public $tableName;
	public function __construct($smartJunction3,$tableName){
		$this->smartJunction3=$smartJunction3;
		$this->tableName=$tableName;
	}
	public function row($id){
		$id=intval($id);
		$queryWhereClause="id=$id";
		$row=$this->smartJunction3->getRow("SELECT * FROM ".$this->tableName." WHERE $queryWhereClause LIMIT 1");
		if($row==null) return null;
		else return new smartJunction3_TableRow($this,$id,$row);
	}
}
class smartJunction3_TableRow implements ArrayAccess{
	public $smartJunction3_Table;
	public $id;
	public $data;
	
	public $sj;
	public $tableName;
	
	public function __construct($smartJunction3_Table,$id,$data){
		$this->smartJunction3_Table=$smartJunction3_Table;
		$this->id=$id;
		$this->data=$data;
		
		$this->sj=$smartJunction3_Table->smartJunction3;
		$this->tableName=$smartJunction3_Table->tableName;
	}
	
	public function offsetSet($offset, $value) {
        if (is_null($offset)) {
            return;
        } else {
            $this->data[$offset] = $value;
            $this->sj->set("UPDATE ".$this->tableName." SET $offset=? WHERE id=?",array($value,$this->id));
        }
    }

    public function offsetExists($offset) {
        return isset($this->data[$offset]);
    }

    public function offsetUnset($offset) {
		$this->sj->set("UPDATE ".$this->tableName." SET $offset=NULL WHERE id=".$this->id);
		$row=$this->sj->getRow("SELECT * FROM ".$this->tableName." WHERE id=".$this->id);
        $this->data[$offset]=$row[$offset];
    }

    public function offsetGet($offset) {
        return isset($this->data[$offset]) ? $this->data[$offset] : null;
    }
}






?>


