<?php

function substringbeforematch($haystack,$needle){
	$strpos1=strpos($haystack,$needle);
	if($strpos1!==false){
		return substr($haystack,0,$strpos1);
	}else return $haystack;
}

function substringaftermatch($haystack,$needle){
	$strpos1=strpos($haystack,$needle);
	if($strpos1!==false){
		return substr($haystack,$strpos1+strlen($needle));
	}else return $haystack;
}

function substringfrommatch($haystack,$needle){
	$strpos1=strpos($haystack,$needle);
	if($strpos1!==false){
		return substr($haystack,$strpos1);
	}else return $haystack;
}
function bytestohumanreadable($bytes){
	$typelist=['bytes','kb','mb','gb','tb','petabyte','exabyte','zettabyte'];
	$typeindex=0;
	$divisor=1024;
	while($bytes>$divisor){
		if($typeindex==count($typelist)-1) break;
		$bytes=round(($bytes/$divisor)*100)/100;
		$typeindex++;
	}
	return $bytes.' '.$typelist[$typeindex];
}

function curlwebpage(){
	$url=func_get_arg(0);
	
	$headers=[];
	
	
	if(func_num_args()>1){
		$headers=func_get_arg(1);
	}
	
	$data=[];
	$data['header']=$headers;
	$tempstring='';
	$gzipdecode=false;
	$setuseragent=true;
	for($i=0;$i<count($headers);$i++){
		$tempstring=strtolower($headers[$i]);
		if(strpos($tempstring,'accept-encoding')!==false && strpos($tempstring,'gzip')!==false) $gzipdecode=true;
		if(strpos($tempstring,'user-agent')!==false) $setuseragent=false;
	}
	
	
	if($setuseragent){
		array_push($data['header'],'User-Agent:Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.140 Safari/537.36');
	}
	

	$success=false;
	$tryCount=0;
	$result='';
	
	while(!$success && $tryCount<5){
		$tryCount++;
		
		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		
		curl_setopt($ch, CURLOPT_HTTPHEADER, $data['header']);
		if($gzipdecode){
			curl_setopt($ch,CURLOPT_ENCODING , "gzip");
		}
		
		$result = curl_exec($ch);
		$success=true;
		if(curl_errno($ch)){
			$success=false;
			sleep(1);
		}
	}
	
	return $result;
}
function curlpost(){
	$url=func_get_arg(0);
	$postdata=func_get_arg(1);
	$headers=[];
	
	array_push($headers,'User-Agent:Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.140 Safari/537.36');
	
	$success=false;
	while(!$success){
	
		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10); 
		
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata);
		
		$result = curl_exec($ch);
		//writedebugappended('curlpost');
		//writedebugappended($result);
		
		$success=true;
		if(curl_errno($ch)){
			$success=false;
			sleep(1);
		}
	
	}
	
	
	return trim($result);
}
function curlpostint(){
	$url=func_get_arg(0);
	$postdata=func_get_arg(1);
	
	$headers=[];
	
	array_push($headers,'User-Agent:Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.140 Safari/537.36');
	
	$success=false;
	while(!$success){
	

		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10); 
		
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata);
		
		$result = curl_exec($ch);
		$success=true;
		if(curl_errno($ch)){
			$success=false;
			sleep(1);
		}
	
	}
	return intval($result);
}
function curlpostwait10int(){
	$url=func_get_arg(0);
	$postdata=func_get_arg(1);
	
	$headers=[];
	
	array_push($headers,'User-Agent:Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.140 Safari/537.36');
	

	$success=false;
	while(!$success){
		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10); 
		curl_setopt($ch, CURLOPT_TIMEOUT, 10);
		
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata);
		
		$result = curl_exec($ch);
		$success=true;
		if(curl_errno($ch)){
			$success=false;
			sleep(1);
		}
	
	}
	
	return intval($result);
}
function curlget(){
	$url=func_get_arg(0);
	
	$headers=[];
	
	array_push($headers,'User-Agent:Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.140 Safari/537.36');
	

	$ch = curl_init($url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	
	$result = curl_exec($ch);
	
	return $result;
}

?>
