<?php

header("Cache-Control: no-cache, must-revalidate");
header('Access-Control-Allow-Origin: *');  

session_start();



require_once('smartjunction.php');
require_once('jsoncontrol.php');
require_once('../config.php');
require_once('systemconfig.php');
require_once('utility.php');
require_once('file.php');

date_default_timezone_set('UTC');

$jc=new JSONcontrol($config);
$sj=$jc->sj;
$GLOBALS['alltablelocks']=[];

function getselfserver(){
	return $GLOBALS['selfserverurl'];
}
function isnull($data){
	return is_null($data);
}
function isnotnull($data){
	return !is_null($data);
}
function notnull($data){
	return !is_null($data);
}
function jsonencode($data){
	return json_encode($data);
}
function jsondecode($data){
	$json=json_decode($data,true);
	if($data!=='null' && isnull($json)) $json=$data;
	return $json;
}
function bcencode($data){
	return base64_encode($data);
}
function bcdecode($data){
	return base64_decode($data);
}
function sjset(){
	if(func_num_args()==2){
		return $GLOBALS['sj']->set(func_get_arg(0),func_get_arg(1));
	}else{
		return $GLOBALS['sj']->set(func_get_arg(0));
	}
}
function sjgetrow(){
	if(func_num_args()==2){
		return $GLOBALS['sj']->getrow(func_get_arg(0),func_get_arg(1));
	}else{
		return $GLOBALS['sj']->getrow(func_get_arg(0));
	}
}
function sjgetlist(){
	if(func_num_args()==2){
		return $GLOBALS['sj']->getlist(func_get_arg(0),func_get_arg(1));
	}else{
		return $GLOBALS['sj']->getlist(func_get_arg(0));
	}
}
function unlockalltable(){
	for($i=0;$i<count($GLOBALS['alltablelocks']);$i++){
		unlocktable($GLOBALS['alltablelocks'][$i]);
	}
}
function printerror($error){
	unlockalltable();
	
	exit('{"error":"'.$error.'"}');
}
function getserverurl(){
	if(func_num_args()==0){
		return $GLOBALS['selfserverurl'];
	}else if(func_num_args()==1){
		$id=func_get_arg(0);
		$row=getrow("SELECT * FROM serverlist WHERE id=?",$id);
		return $row['url'];
	}
}
function unlocktable($tableid){
	$row=getrow("SELECT * FROM tablelist WHERE id=?",[$tableid]);
	if(isnull($row)) printerror("Did not find table in this server ".getserverurl());
	else{
		if(isset($GLOBALS[$tableid.'lockkey'])){
			$data=issuereadcommand(getserverurl($row['server']),'unlocktable',['table'=>$tableid,'lock'=>$GLOBALS[$tableid.'lockkey']]);
			set("DELETE FROM lockkeepalive WHERE tableid=? AND keystring=?",[$tableid,$GLOBALS[$tableid.'lockkey']]);
			unset($GLOBALS[$tableid.'lockkey']);
			return jsondecode($data);
		}
	}
}
function gettablelock($tableid){
	if(!in_array($tableid,$GLOBALS['alltablelocks'])){
		$row=getrow("SELECT * FROM tablelist WHERE id=?",[$tableid]);
		if(isnull($row)) printerror("Did not find table in this server ".getserverurl());
		else{
			$data=issuereadcommand(getserverurl($row['server']),'gettablelock',['table'=>$tableid]);
			$lock=jsondecode($data);
			if(isnull($lock)) printerror("Cannot obtain lock on table ".$tableid);
			$GLOBALS[$tableid.'lockkey']=$lock;
			set("INSERT INTO lockkeepalive (tableid,keystring,timestamp) VALUES(?,?,?)",[$tableid,$lock,time()]);
			issuereadcommand($GLOBALS['selfserverurl'],'lockkeepalive',[$tableid,$lock,$row['server']]);
			array_push($GLOBALS['alltablelocks'],$tableid);
			return $lock;
		}
	}else{
		return $GLOBALS[$tableid.'lockkey'];
	}
	
}
function printlock($tableid){
	echo $GLOBALS[$tableid.'lockkey'].'<br>';
}
function locktable($tableid){
	return gettablelock($tableid);
}
function checktablelock($tableid){
	if(in_array($tableid,$GLOBALS['alltablelocks'])) return true;
	return false;
}
function removetablelock($tableid){
	return unlocktable($tableid);
}
function executegetrowquery($commanddata){
	$timestart=time();
	$timestart2=microtime(TRUE);
	$tableid=$commanddata['table'];
	
	if(strpos($commanddata['query'],' table ')!==false){
		$templatetable=getrow("SELECT * FROM selftablelist WHERE id=?",[$tableid])['tablename'];
		$commanddata['query']=replaceall(' table ',' '.$templatetable.' ',$commanddata['query']);
	}
	
	$row=getrow($commanddata['query'],$commanddata['args']);
	initializestatisticsreadrows($tableid,$timestart);
	$duration=round((microtime(TRUE)-$timestart2)*1000);
	updatestatisticsreadrows($tableid,$timestart,$duration);
	return $row;
}
function executegetlistquery($commanddata){
	$timestart=time();
	$timestart2=microtime(TRUE);
	$tableid=$commanddata['table'];
	
	if(strpos($commanddata['query'],' table ')!==false){
		$templatetable=getrow("SELECT * FROM selftablelist WHERE id=?",[$tableid])['tablename'];
		$commanddata['query']=replaceall(' table ',' '.$templatetable.' ',$commanddata['query']);
	}
	
	$row=getlist($commanddata['query'],$commanddata['args']);
	initializestatisticsreadrows($tableid,$timestart);
	$duration=round((microtime(TRUE)-$timestart2)*1000);
	updatestatisticsreadrows($tableid,$timestart,$duration);
	return $row;
}
function executesetquery($commanddata){
	$timestart=time();
	$timestart2=microtime(TRUE);
	$tableid=$commanddata['table'];
	$underlock=false;
	$newlock='';
	if(gettype($tableid)=='array'){
		
		$lockkey=$tableid['lock'];
		$tableid=$tableid['id'];
		$underlock=true;
		
		//set("INSERT INTO selftablelockqueue (tableid,keystring,time) VALUES (?,?,?)",[$tableid,$lockkey,time()]);
		query("START TRANSACTION");
		$tablerow=getrow("SELECT * FROM selftablelist WHERE id=? FOR UPDATE",$tableid);
		$exitthis=false;
		while($tablerow['lockkey']!=$lockkey){
			if($tablerow['locktime']<time()-600){
				set("DELETE FROM selftablelockqueue WHERE tableid=? AND keystring=?",[$tableid,$tablerow['lockkey']]);
				$lockrow=getrow("SELECT * FROM selftablelockqueue WHERE tableid=? ORDER BY time ASC LIMIT 1",$tableid);
				if(isnull($lockrow)){
					query("COMMIT");
					$exitthis=true;
					break;
				}else{
					set("UPDATE selftablelist SET lockkey=?,locktime=? WHERE id=?",[$lockrow['keystring'],time(),$tableid]);
					query("COMMIT");
				}
			}else{
				query("COMMIT");
				sleep(1);
			}
			query("START TRANSACTION");
			$tablerow=getrow("SELECT * FROM selftablelist WHERE id=?",$tableid);
		}
		if($exitthis) return bcopensslencode(jsonencode(0));
		
		$newlock=$lockkey;
		
		/*
		$newlock=randomstring(250);
		$newrow=getrow("SELECT * FROM selftablelockqueue WHERE tableid=? AND keystring=?",[$tableid,$newlock]);
		while(!isnull($newrow)){
			$newlock=randomstring(250);
			$newrow=getrow("SELECT * FROM selftablelockqueue WHERE tableid=? AND keystring=?",[$tableid,$newlock]);
		}
		set("UPDATE selftablelist SET lockkey=?, locktime=? WHERE id=?",[$newlock,time(),$tableid]);
		set("UPDATE selftablelockqueue SET keystring=? WHERE tableid=? AND keystring=?",[$newlock,$tableid,$lockkey]);
		*/
		
		query("COMMIT");
		
		
	}
	
	if(strpos($commanddata['query'],' table ')!==false){
		$templatetable=getrow("SELECT * FROM selftablelist WHERE id=?",[$tableid])['tablename'];
		$commanddata['query']=replaceall(' table ',' '.$templatetable.' ',$commanddata['query']);
	}
	
	if(strpos($commanddata['query'],';')!==false){
		$querylistforsemicolon=explode(';',$commanddata['query']);
		array_pop($querylistforsemicolon);
		$argsperquery=count($commanddata['args'])/count($querylistforsemicolon);
	}else{
		$querylistforsemicolon=[$commanddata['query']];
		$argsperquery=count($commanddata['args']);
	}
	
	$countforsemicolon=0;
	foreach($querylistforsemicolon as $querystringforsemicolon){
		$argsforsemicolon=[];
		for($i=0;$i<$argsperquery;$i++){
			array_push($argsforsemicolon,$commanddata['args'][($countforsemicolon*$argsperquery)+$i]);
		}
		
		if(strpos($querystringforsemicolon,'DELETE FROM ')!==false){
			query("START TRANSACTION");
			$temprow0=getrow("SELECT * FROM selftablelist WHERE id=? FOR UPDATE",$tableid);
			
			$query2=replaceall('DELETE FROM ','SELECT COUNT(tableid) AS totalrows FROM ',$querystringforsemicolon);
			
			
			
			
			$temprow=getrow($query2,$argsforsemicolon);
			
			
			if(!isnull($temprow)){
				$totalrows2=$temprow['totalrows'];
				set("UPDATE selftablelist SET totalrows=? WHERE id=?",[$temprow0['totalrows']-$totalrows2,$tableid]);
			}
			$row=set($querystringforsemicolon,$argsforsemicolon);
			query("COMMIT");
		}else{
			if($underlock){
				query("START TRANSACTION");
				$row=set($querystringforsemicolon,$argsforsemicolon);
				query("COMMIT");
			}else{
				$row=set($querystringforsemicolon,$argsforsemicolon);
			}
		}
		
		
	
	
		$countforsemicolon++;
	}
	
	
	
	initializestatisticswriterows($tableid,$timestart);
	$duration=round((microtime(TRUE)-$timestart2)*1000);
	updatestatisticswriterows($tableid,$timestart,$duration);
	
	$returndata=$row;
	if($underlock){
		$returndata=["newlock"=>$newlock];
	}
	
	
	return $returndata;
}
function getrow(){
	if(func_num_args()==2){
		return $GLOBALS['sj']->getrow(func_get_arg(0),func_get_arg(1));
	}else if(func_num_args()==1){
		return $GLOBALS['sj']->getrow(func_get_arg(0));
	}else if(func_num_args()==3){
		$tableid=func_get_arg(0);
		$query=func_get_arg(1);
		$args=func_get_arg(2);
		if(gettype($args)!=='array') $args=[$args];
		
		if(strpos($query,' WHERE ')!==false){
			if(strpos($query,' WHERE tableid=?')===false){
				$query=replaceall(' WHERE ',' WHERE tableid=? AND ',$query);
				array_unshift($args,$tableid);
			}
		}
		
		
		
		$row=getrow("SELECT * FROM tablelist WHERE id=?",[$tableid]);
		if(isnull($row)) printerror("Did not find table in this server ".getserverurl());
		else{
			if(getserverurl($row['server'])!=getselfserver()){
				$data=issuereadcommand(getserverurl($row['server']),'executegetrowquery',['query'=>$query,'args'=>$args,'table'=>$tableid]);
				return jsondecode($data);
			}else{
				return executegetrowquery(['query'=>$query,'args'=>$args,'table'=>$tableid]);
			}
		}
	}
}
function getlist(){
	if(func_num_args()==2){
		return $GLOBALS['sj']->getlist(func_get_arg(0),func_get_arg(1));
	}else if(func_num_args()==1){
		return $GLOBALS['sj']->getlist(func_get_arg(0));
	}else if(func_num_args()==3){
		$tableid=func_get_arg(0);
		$query=func_get_arg(1);
		$args=func_get_arg(2);
		if(gettype($args)!=='array') $args=[$args];
		
		if(strpos($query,' WHERE ')!==false){
			if(strpos($query,' WHERE tableid=?')===false){
				$query=replaceall(' WHERE ',' WHERE tableid=? AND ',$query);
				array_unshift($args,$tableid);
			}
		}
		
		$row=getrow("SELECT * FROM tablelist WHERE id=?",[$tableid]);
		if(isnull($row)) printerror("Did not find table in this server ".getserverurl());
		else{
			if(getserverurl($row['server'])!=getselfserver()){
				$data=issuereadcommand(getserverurl($row['server']),'executegetlistquery',['query'=>$query,'args'=>$args,'table'=>$tableid]);
				return jsondecode($data);
			}else{
				return executegetlistquery(['query'=>$query,'args'=>$args,'table'=>$tableid]);
			}
			
		}
	}
}
function arraytofile($file,$array){
	file_put_contents($file,print_r($array, true));
}
function set(){
	if(func_num_args()==2){
		return $GLOBALS['sj']->set(func_get_arg(0),func_get_arg(1));
	}else if(func_num_args()==1){
		return $GLOBALS['sj']->set(func_get_arg(0));
	}else if(func_num_args()==3){
		$tableid=func_get_arg(0);
		if(gettype($tableid)=='array'){
			$tableid2=$tableid['id'];
		}else{
			$tableid2=$tableid;
		}
		$query=func_get_arg(1);
		$args=func_get_arg(2);
		if(gettype($args)!=='array') $args=[$args];
		
		if(strpos($query,' WHERE ')!==false){
			if(strpos($query,' WHERE tableid=?')===false){
				$query=replaceall(' WHERE ',' WHERE tableid=? AND ',$query);
				array_unshift($args,$tableid2);
			}
		}
		
		
		
		$row=getrow("SELECT * FROM tablelist WHERE id=?",[$tableid2]);
		if(isnull($row)) printerror("Did not find table in this server ".getserverurl());
		else{
			if(getserverurl($row['server'])!=getselfserver()){
				$data=issuereadcommand(getserverurl($row['server']),'executesetquery',['query'=>$query,'args'=>$args,'table'=>$tableid]);
				return jsondecode($data);
			}else{
				return executesetquery(['query'=>$query,'args'=>$args,'table'=>$tableid]);
			}
			
		}
	}
}
function setunderlock(){
	if(func_num_args()==2){
		if(isset($GLOBALS[func_get_arg(0).'lockkey'])){
			$returnvalue=set(['id'=>func_get_arg(0),'lock'=>$GLOBALS[func_get_arg(0).'lockkey']],func_get_arg(1),[]);
			if(gettype($returnvalue)==='array' && isset($returnvalue['newlock'])){
				$GLOBALS[func_get_arg(0).'lockkey']=$returnvalue['newlock'];
				return true;
			}else return false;
		}else{
			printerror("Lock key not found");
		}
	}else if(func_num_args()==3){
		if(isset($GLOBALS[func_get_arg(0).'lockkey'])){
			$returnvalue=set(['id'=>func_get_arg(0),'lock'=>$GLOBALS[func_get_arg(0).'lockkey']],func_get_arg(1),func_get_arg(2));
			if(gettype($returnvalue)==='array' && isset($returnvalue['newlock'])){
				$GLOBALS[func_get_arg(0).'lockkey']=$returnvalue['newlock'];
				return true;
			}else return false;
		}else{
			printerror("Lock key not found");
		}
	}
}
function arraysplice(&$array1,$index){
	array_splice($array1,$index,1);
}
function findandremovefromarray(&$array1,$target){
	for($i=0;$i<count($array1);$i++){
		if($array1[$i]===$target){
			arraysplice($array1,$i);
			$i--;
		}
	}
}
function replaceall($search,$replace,$string){
	if(strpos($replace,$search)!==false){
		$string=str_replace($search,$replace,$string);
	}else{
		while(strpos($string,$search)!==false){
			$string=str_replace($search,$replace,$string);
		}
	}
	return $string;
}



function query($query){
	$sj=$GLOBALS['sj'];
	return $sj->query($query);
}

function begintransaction(){
	query("START TRANSACTION");
}
function starttransaction(){
	query("START TRANSACTION");
}
function endtransaction(){
	query("COMMIT");
}

function stringtoobjectlist(){
	$namelist=[];
	$valuelist=[];
	$total=0;
	$lastname='';
	for($i=0;$i<func_num_args();$i++){
		if($i%2==0){
			$lastname=func_get_arg($i);
			array_push($namelist,$lastname);
			$lastname=func_get_arg($i);
			$total++;
		}
		else{
			if($lastname=='uneditable'){
				array_push($valuelist,[func_get_arg($i)]);
			}else if(func_get_arg($i)==''){
				array_push($valuelist,['']);
			}else{
				array_push($valuelist,explode(',',func_get_arg($i)));
			}
			
		}
	}
	
	$returnlist=[];
	for($i=0;$i<count($valuelist[0]);$i++){
		$object1=[];
		for($j=0;$j<$total;$j++){
			if(isset($valuelist[$j][$i])) $object1[$namelist[$j]]=$valuelist[$j][$i];
			else $object1[$namelist[$j]]=$valuelist[$j][0];
		}
		array_push($returnlist,$object1);
	}
	
	return $returnlist;
}

function ordinal($number) {
    $ends = array('th','st','nd','rd','th','th','th','th','th','th');
    if ((($number % 100) >= 11) && (($number%100) <= 13))
        return $number. 'th';
    else
        return $number. $ends[$number % 10];
}


function getrowbyid($tableid,$rowid){
	return getrow($tableid,"SELECT * FROM table WHERE tableid=? AND id=?",[$tableid,$rowid]);
}
function get(){
	if(gettype(func_get_arg(1))=='array'){
		return getrow(func_get_arg(0),func_get_arg(1));
	}else{
		if(func_num_args()==3){
			$sj=func_get_arg(0);
			$tableName=func_get_arg(1);
			$id=func_get_arg(2);
		}else if(func_num_args()==2){
			$sj=$GLOBALS['sj'];
			$tableName=func_get_arg(0);
			$id=func_get_arg(1);
		}
		$name=$tableName;
		$row=$sj->getrow("SELECT * FROM $name WHERE id=? LIMIT 1",array($id));
		return $row;
	}
}

function getFormErrorObject(){
	if(func_num_args()==2){
		return [
			"success"=>0,
			"error"=>[
				[
					"field"=>func_get_args()[0],
					"text"=>func_get_args()[1]
				]
			]
		];
	}else if(func_num_args()==1){
		return [
			"success"=>0,
			"error"=>[
				[
					"text"=>func_get_args()[0]
				]
			]
		];
	}
}
function formError(){
	if(func_num_args()==2){
		return [
			"success"=>0,
			"error"=>[
				[
					"field"=>func_get_args()[0],
					"text"=>func_get_args()[1]
				]
			]
		];
	}else if(func_num_args()==1){
		return [
			"success"=>0,
			"error"=>[
				[
					"text"=>func_get_args()[0]
				]
			]
		];
	}
}
function getFormSingleErrorObject($errorString){
	return [
		"success"=>0,
		"error"=>$errorString
	];
}
function getFormSuccess(){
	return ['success'=>1];
}
function formSuccess(){
	return ['success'=>1];
}
function integer_to_custom_b64($number){
	$chars=['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','0','1','2','3','4','5','6','7','8','9','-','_'];
	
	$output='';
	
	while(true){
		if($number<64){
			$output=$chars[$number].$output;
			break;
		}
		else{
			$floored=floor($number/64);
			$newNumber=$floored*64;
			$remainingNumber=$number-$newNumber;
			$output=$chars[$remainingNumber].$output;
			$number=$newNumber/64;
		}
	}
	
	return $output;
}
function randomCustomB64($length){
	$chars=['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','0','1','2','3','4','5','6','7','8','9','-','_'];
	
	$output='';
	
	for($i=0;$i<$length;$i++){
		$output.=$chars[random_int(0,63)];
	}
	
	return $output;
}
function randomeasystring($length){
	$chars=['a','b','c','d','e','f','g','h','i','j','k','l','m','n','p','q','r','s','t','u','v','w','x','y','z','1','2','3','4','5','6','7','8','9'];
	
	$lastindex=count($chars)-1;
	
	$output='';
	
	for($i=0;$i<$length;$i++){
		$output.=$chars[random_int(0,$lastindex)];
	}
	
	return $output;
}
function randomstring($length){
	return randomCustomB64($length);
}
function increaseid($id){
	$chars=['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','0','1','2','3','4','5','6','7','8','9','-','_'];
	
	
	$index=strlen($id)-1;
	$carryover=1;
	
	while($carryover==1){
		$carryover=0;
		if($index>=0){
			$numval=array_search($id[$index],$chars);
			$numval++;
			
			if($numval>=count($chars)){
				$carryover=1;
				$id[$index]=$chars[0];
			}else{
				$id[$index]=$chars[$numval];
			}
			$index--;
		}else{
			$id=$chars[0].$id;
		}
	}
	
	return $id;
}



function hashPassword($pass){
	return password_hash($pass,PASSWORD_DEFAULT);
}

function getNewID($sj,$tableName){
	$row=$sj->getrow("SELECT * FROM tablespecs WHERE tablename=?",$tableName);
	if(is_null($row)){
		$idlength=11;
		$sj->set("INSERT INTO tablespecs (tablename,idlength) VALUES (?,?)",[$tableName,$idlength]);
	}else{
		$idlength=$row['idlength'];
	}
	
	$randomString=randomString($idlength);
	$row=$sj->getrow("SELECT * FROM $tableName WHERE id=?",$randomString);
	
	while(!is_null($row)){
		$sj->set("UPDATE tablespecs SET idlength=idlength+1 WHERE tablename=?",$tableName);
		$idlength++;
		$randomString=randomString($idlength);
		$row=$sj->getrow("SELECT * FROM $tableName WHERE id=?",$randomString);
	}
	
	return $randomString;
}

function insert(){
	
	if(func_num_args()==2){
		$sj=func_get_arg(0);
		$tableName=func_get_arg(1);
	}else if(func_num_args()==1){
		$sj=$GLOBALS['sj'];
		$tableName=func_get_arg(0);
	}
	
	
	
	$randomString=getNewID($sj,$tableName);
	
	$result=$sj->set("INSERT INTO $tableName (id) VALUES (?)",$randomString);

	
	while(!$result){
		$randomString=getNewID($sj,$tableName);
		$result=$sj->set("INSERT INTO $tableName (id) VALUES (?)",$randomString);
	}
	
	
	return $randomString;
}

function getDynMode($data){
	if(isset($data['dynamicTableMode'])) return $data['dynamicTableMode'];
	if(isset($_POST['dynamicTableMode'])) return $_POST['dynamicTableMode'];
	return '';
}


function insertZeroParent(){
	
	$sj=func_get_arg(0);
	$tableName=func_get_arg(1);
	if(func_num_args()==3) $pushFrontFlag=func_get_arg(2); else $pushFrontFlag=false;
	
	
	$row=$sj->getrow("SHOW COLUMNS FROM $tableName LIKE 'orderColumn'",[]);
	if(is_null($row)){
		$id=insert($sj,$tableName);
		return $id;
	}else{
		if($pushFrontFlag){
			$sj->set("UPDATE $tableName SET orderColumn=orderColumn+1",[]);
			$orderColumn=1;
		}else{
			$row=$sj->getrow("SELECT orderColumn FROM $tableName ORDER BY orderColumn DESC LIMIT 1",[]);
			if(is_null($row)) $orderColumn=1;
			else $orderColumn=$row['orderColumn']+1;
		}
		$id=insert($sj,$tableName);
		$sj->set("UPDATE $tableName SET orderColumn=? WHERE id=?",[$orderColumn,$id]);
		
		return $id;
	}
	
}
function insertSingleParent(){
	
	$sj=func_get_arg(0);
	$tableName=func_get_arg(1);
	$parentColumn=func_get_arg(2);
	$parentColumnValue=func_get_arg(3);
	if(func_num_args()==5) $pushFrontFlag=func_get_arg(4); else $pushFrontFlag=false;
	
	
	$row=$sj->getrow("SHOW COLUMNS FROM $tableName LIKE 'orderColumn'",[]);
	if(is_null($row)){
		$id=insert($sj,$tableName);
		$sj->set("UPDATE $tableName SET $parentColumn=? WHERE id=?",[$parentColumnValue,$id]);
		return $id;
	}else{
		if($pushFrontFlag){
			$sj->set("UPDATE $tableName SET orderColumn=orderColumn+1 WHERE $parentColumn=?",[$parentColumnValue]);
			$orderColumn=1;
		}else{
			$row=$sj->getrow("SELECT orderColumn FROM $tableName WHERE $parentColumn=? ORDER BY orderColumn DESC LIMIT 1",[$parentColumnValue]);
			if(is_null($row)) $orderColumn=1;
			else $orderColumn=$row['orderColumn']+1;
		}
		$id=insert($sj,$tableName);
		$sj->set("UPDATE $tableName SET $parentColumn=? WHERE id=?",[$parentColumnValue,$id]);
		$sj->set("UPDATE $tableName SET orderColumn=? WHERE id=?",[$orderColumn,$id]);
		
		return $id;
	}
	
}

function singleParentOrderUp($sj,$tableName,$id,$parentColumn){
	$row=$sj->getrow("SELECT * FROM $tableName WHERE id=?",[$id]);
	$parentColumnValue=$row[$parentColumn];
	$orderColumn=$row['orderColumn'];
	
	if($orderColumn>1){
		$id2=$id;
		$id1=$sj->getrow("SELECT * FROM $tableName WHERE $parentColumn=? AND orderColumn=?",[$parentColumnValue,$orderColumn-1])['id'];
		
		$sj->set("UPDATE $tableName SET orderColumn=? WHERE id=?",[$orderColumn,$id1]);
		$sj->set("UPDATE $tableName SET orderColumn=? WHERE id=?",[$orderColumn-1,$id2]);
		
	}
}
function singleParentOrderDown($sj,$tableName,$id,$parentColumn){
	$row=$sj->getrow("SELECT * FROM $tableName WHERE id=?",[$id]);
	$parentColumnValue=$row[$parentColumn];
	$orderColumn=$row['orderColumn'];
	
	if(true){
		$id1=$id;
		$id2=$sj->getrow("SELECT * FROM $tableName WHERE $parentColumn=? AND orderColumn=?",[$parentColumnValue,$orderColumn+1]);
		
		if(!is_null($id2)){
			$id2=$id2['id'];
			
			$sj->set("UPDATE $tableName SET orderColumn=? WHERE id=?",[$orderColumn+1,$id1]);
			$sj->set("UPDATE $tableName SET orderColumn=? WHERE id=?",[$orderColumn,$id2]);
		}
		
	}
}


function singleParentDelete($sj,$tableName,$id,$parentColumn){
	$row=$sj->getrow("SHOW COLUMNS FROM $tableName LIKE 'orderColumn'",[]);
	if(is_null($row)){
		$sj->set("DELETE FROM  $tableName  WHERE id=?",[$id]);
	}else{
		$row=$sj->getrow("SELECT * FROM $tableName WHERE id=?",[$id]);
		$sj->set("UPDATE $tableName SET orderColumn=orderColumn-1 WHERE $parentColumn=? && orderColumn>?",[$row[$parentColumn],$row['orderColumn']]);
		$sj->set("DELETE FROM $tableName WHERE id=?",[$id]);
	}
}





function syncTable($args){
	
	
	$sj=$args['connection'];
	$data=$args['data'];
	$tableName=$args['query'];
	$columnNames=$args['columns'];
	$extraClause=$args['querysearch'];
	$extraData=$args['querysearchparams'];
	
	
	if(isset($args['rowsatonce'])) $numberOfRowsAtOnce=$args['rowsatonce'];
	else $numberOfRowsAtOnce=10;
	
	
	$sortmodes=$args['sortmodes'];
	$searchmodes=$args['searchmodes'];
	$showcount=$args['showcount'];
	$useoffset=$args['useoffset'];
	
	
	
	
	
	
	$columnNamesCount=count($columnNames);
	
	
	$sortmodeslength=count($sortmodes);
	if($sortmodeslength==0){
		$orderColumn=$columnNames[0];
		$orderMode="ASC";
	}else{
		$orderColumn=$sortmodes[0][0];
		$orderMode=$sortmodes[0][1];
	}
	if(isset($data['orderColumn'])){
		
		for($i=0;$i<$sortmodeslength;$i++){
			if($sortmodes[$i][0]===$data['orderColumn'] && $sortmodes[$i][1]===$data['orderMode']){
				$orderColumn=$sortmodes[$i][0];
				$orderMode=$sortmodes[$i][1];
				break;
			}
		}
	}	
	
	
	$queryDataArray=$extraData;
	$searchQueryStringAppend=$extraClause;
	if(isset($data['search'])){
		$searchmodeslength=count($searchmodes);
		foreach($data['search'] as $searchElem){
			$searchColumnName='';
			$searchcolumnmode='';
			
			
			for($i=0;$i<$searchmodeslength;$i++){
				if($searchmodes[$i][0]===$searchElem['column'] && $searchmodes[$i][1]===$searchElem['mode']){
					$searchColumnName=$searchmodes[$i][0];
					$searchcolumnmode=$searchmodes[$i][1];
					break;
				}
			}
			if($searchColumnName!=''){
				if($searchcolumnmode=='equal'){
					$searchQueryStringAppend.=" AND $searchColumnName=? ";
					array_push($queryDataArray,$searchElem['term']);
				}
				else if($searchcolumnmode=='middlematch'){
					$formattedstring=strtolower(trim($searchElem['term']));
					$explodedstring=explode(' ',$formattedstring);
					foreach($explodedstring as $stringtemp){
						$searchQueryStringAppend.=" AND LOWER($searchColumnName) LIKE ? ";
						array_push($queryDataArray,'%'.$stringtemp.'%');
					}
					
				}
				else if($searchcolumnmode=='fromfirst'){
					$searchQueryStringAppend.=" AND LOWER($searchColumnName) LIKE ? ";
					array_push($queryDataArray,'%'.strtolower($searchElem['term']).'%');
				}
				else if($searchcolumnmode=='greaterThanOrEqualTo'){
					$searchQueryStringAppend.=" AND $searchColumnName>=? ";
					array_push($queryDataArray,$searchElem['term']);
				}
				else if($searchcolumnmode=='lessThanOrEqualTo'){
					$searchQueryStringAppend.=" AND $searchColumnName<=? ";
					array_push($queryDataArray,$searchElem['term']);
				}
				else if($searchcolumnmode=='lessthan'){
					$searchQueryStringAppend.=" AND $searchColumnName<? ";
					array_push($queryDataArray,$searchElem['term']);
				}
				else if($searchcolumnmode=='greaterthan'){
					$searchQueryStringAppend.=" AND $searchColumnName>? ";
					array_push($queryDataArray,$searchElem['term']);
				}
				
			}
		}
	}
	
	
				
	
	
	
	
	$offset=0;
	if(isset($data['offset']) && $useoffset) $offset=intval($data['offset']);
	
	
	$totalRows=null;
	if($showcount){
		$totalRows=$sj->getrow(
			"SELECT COUNT(".$columnNames[0].") AS totalRows FROM $tableName 
			WHERE TRUE $searchQueryStringAppend 
			",
			
			$queryDataArray
		)['totalRows'];
	}
	
	
	
	$columnSelectQuery='';
	$tableName=trim($tableName);
	foreach($columnNames as $columnName){
		/*
		if(strpos($columnName,'.')!==false && strpos($columnName,$tableName)===0){
			
			$columnSelectQuery.=",$columnName AS '".substr($columnName,strpos($columnName,'.')+1)."'";
		}else{
			$columnSelectQuery.=",$columnName AS '$columnName'";
		}
		*/
		$columnSelectQuery.=",$columnName AS '$columnName'";
		
	}
	$columnSelectQuery=substr($columnSelectQuery,1);
	
	
	
	$result=$sj->getlist(
		"SELECT $columnSelectQuery FROM $tableName 
		WHERE TRUE $searchQueryStringAppend 
		ORDER BY $orderColumn $orderMode LIMIT $offset,$numberOfRowsAtOnce",
		
		$queryDataArray
	);
	
	//echo "SELECT $columnSelectQuery FROM $tableName  WHERE TRUE $searchQueryStringAppend  ORDER BY $orderColumn $orderMode LIMIT $offset,$numberOfRowsAtOnce";
	
	
	return [
		'totalRows'=>$totalRows,
		'rowsPerPage'=>$numberOfRowsAtOnce,
		'data'=>$result,
		'ordercolumn'=>$orderColumn,
		'ordermode'=>$orderMode
	];
}

function editColumn($sj,$tableName,$id,$columnName,$columnValue){
	$sj->set("UPDATE $tableName SET $columnName=? WHERE id=?",[$columnValue,$id]);
}
function updateColumn($sj,$tableName,$id,$columnName,$columnValue){
	$sj->set("UPDATE $tableName SET $columnName=? WHERE id=?",[$columnValue,$id]);
}







//$_SESSION['chiralLoggedIn'];
//$_SESSION['chiralLoginID'];
//$_SESSION['chiralLoginPasswordHash'];











 



function iterateFiles($postFieldName,$callback){
	if(gettype($_FILES[$postFieldName]['name'])=='array'){
		for($i=0;$i<count($_FILES[$postFieldName]['name']);$i++){
			
		}
	}
	
}

function postFileSize($postFieldName){
	return filesize($_FILES[$postFieldName]["tmp_name"]);
}
function postSaveFile($sj,$postFieldName){
	$id=insert($sj,'file');
	$row=get($sj,'file',$id);
	rename($_FILES[$postFieldName]['tmp_name'],'files/file/'.$row['alphaID']);
	return $id;
}
function postDeleteFile($sj,$id){
	$row=get($sj,'file',$id);
	unlink('files/file/'.$row['alphaID']);
	$sj->set("DELETE FROM file WHERE id=?",$id);
}

function postJpegHook($sj,$maxFileSize,$tableName,$rowID,$columnName){
	$fileID=0;
	if(postFileSize('file')<$maxFileSize){
		if(gettype($rowID)==='integer') $idColumnName='id';
		else $idColumnName='alphaID';
		
		$tableRow=$sj->getrow("SELECT * FROM $tableName WHERE $idColumnName=?",$rowID);
		if($tableRow[$columnName]!=0){
			postDeleteFile($sj,$tableRow[$columnName]);
			$sj->set("UPDATE $tableName SET $columnName=0 WHERE id=?",$tableRow['id']);
		}
		
		if(postFileSize('file')>0){
			$fileID=postSaveFile($sj,'file');
			$sj->set("UPDATE $tableName SET $columnName=? WHERE id=?",[$fileID,$tableRow['id']]);
		}
	}
	return $fileID;
}
function postTextHook($sj,$tableName,$rowID,$columnName){
	if(gettype($rowID)==='integer') $idColumnName='id';
	else $idColumnName='alphaID';
		
	$tableRow=$sj->getrow("SELECT * FROM $tableName WHERE $idColumnName=?",$rowID);
		
	$sj->set("UPDATE $tableName SET $columnName=? WHERE id=?",[$_POST['text'],$tableRow['id']]);
}
function postGetFile($sj,$id){
	$row=get($sj,'file',$id);
	if(is_null($row)) return '';
	else return $row['alphaID'];
}
function searchexploded($value,$column){
	$namestring=trim($value);
	$explodedstring=explode(' ',$namestring);
	$querystring='';
	$valuelist=[];
	$count=0;
	foreach($explodedstring as $string){
		if($count==0) $querystring.=" LOWER($column) LIKE ?";
		else $querystring.=" AND LOWER($column) LIKE ?";
		array_push($valuelist,'%'.$string.'%');
		$count++;
	}
	return [$querystring,$valuelist];
}
















function getserverlistwithoutself(){
	$serverlist=getlist("SELECT url FROM serverlist WHERE url!=?",[$GLOBALS['selfserverurl']]);
	$serverurllist=[];
	foreach($serverlist as $serverrow){
		array_push($serverurllist,$serverrow['url']);
	}
	return $serverurllist;
}
function getserverlist(){
	$serverlist=getlist("SELECT url FROM serverlist",[]);
	$serverurllist=[];
	foreach($serverlist as $serverrow){
		array_push($serverurllist,$serverrow['url']);
	}
	return $serverurllist;
}
function updateserverlist($targetserverurl){
	$data=issuereadcommand($targetserverurl,'readfile',['filedestination'=>'../serverlist']);
	
	
	
	issuewritecommand('writefile',['filedestination'=>'../serverlist','filecontent'=>$data]);
	
	$serverlist=explode("\n",$data);
	
	set("UPDATE serverlist SET weight=0, cumulativeweight=0",[]);
	
	foreach($serverlist as $serverrow){
		$serverrow=explode("\t",$serverrow);
		if(count($serverrow)>=3){
			if($serverrow[2]==='live'){
				issuewritecommand('writefile',['filedestination'=>'serverstatus','filecontent'=>'live'],[$serverrow[0]]);
			}else{
				issuewritecommand('writefile',['filedestination'=>'serverstatus','filecontent'=>'disabled'],[$serverrow[0]]);
			}
			
			$row=getrow("SELECT * FROM serverlist WHERE url=?",[$serverrow[0]]);
			if(isnull($row)){
				$index=1;
				$row=getrow("SELECT * FROM serverlist ORDER BY id DESC LIMIT 1",[]);
				if(!isnull($row)) $index=$row['id']+1;
				set("INSERT INTO serverlist (id,url,weight) VALUES (?,?,?)",[$index,$serverrow[0],$serverrow[1]]);
			}else if($serverrow[2]==='live'){
				set("UPDATE serverlist SET weight=? WHERE url=?",[$serverrow[1],$serverrow[0]]);
			}
		}
	}
	
	
	
	$allservers=getlist("SELECT * FROM serverlist WHERE weight>0 ORDER BY id ASC");
	$cumulweight=0;
	foreach($allservers as $server){
		$cumulweight+=$server['weight'];
		set("UPDATE serverlist SET cumulativeweight=? WHERE id=?",[$cumulweight,$server['id']]);
	}
	$allservers=getlist("SELECT * FROM serverlist ORDER BY id ASC");
	
	issuewritecommand('writefile',['filedestination'=>'updatepointer','filecontent'=>randomstring(20)]);
	issuewritecommand('updatemysqlserverlist',['allservers'=>$allservers]);
}
function getrandomserver(){
	$row=getrow("SELECT * FROM serverlist ORDER BY cumulativeweight DESC LIMIT 1");
	if(isnull($row)) return $GLOBALS['selfserverurl'];
	else{
		$randomnumber=random_int(0,PHP_INT_MAX)/PHP_INT_MAX;
		$randomnumber=$randomnumber*$row['cumulativeweight'];
		$row=getrow("SELECT * FROM serverlist WHERE cumulativeweight>? ORDER BY cumulativeweight ASC LIMIT 1",[$randomnumber]);
		if(isnull($row)) return $GLOBALS['selfserverurl'];
		else return $row['url'];
	}
}
function randomserver(){
	return getrandomserver();
}
function randomserverid(){
	$server=getrandomserver();
	$row=getrow("SELECT * FROM serverlist WHERE url=?",[$server]);
	return $row['id'];
}
function regeneratekey(){
	issuewritecommand('regeneratekey',['filestring'=>generatenewopensslkeyfilestring()]);
}
function cloneserverfiles($targetserverurl){
	$filelist=[
		'../index.php',
		'backend.php',
		'file.php',
		'indexinitialize.php',
		'initialize.php',
		'jquery.js',
		'jsoncontrol.js',
		'jsoncontrol.php',
		'm.js',
		'main.js',
		'mextended.js',
		'routing.js',
		'smartjunction.php',
	];
	foreach($filelist as $file){
		$data=issuereadcommand($targetserverurl,'readfile',['filedestination'=>$file]);
		issuewritecommand('writefile',['filedestination'=>$file,'filecontent'=>$data]);
	}
	
	updateserverlist($targetserverurl);
}
function generateopensslkeyandiv(){
	//file_put_contents('file.php',generatenewopensslkeyfilestring());
}
function generatenewopensslkeyfilestring(){
	$cipher = "aes-256-cbc-hmac-sha1";
	$ivlen = openssl_cipher_iv_length($cipher);
	$iv = openssl_random_pseudo_bytes($ivlen);
	$key = openssl_random_pseudo_bytes(256);
	return "<?php\n\$opensslcipher=\"aes-256-cbc-hmac-sha1\";\n\$openssliv=base64_decode(\"".base64_encode($iv)."\");\n\$opensslkey=base64_decode(\"".base64_encode($key)."\");\n?>";
}
function opensslencode($message){
	return openssl_encrypt($message, $GLOBALS['opensslcipher'], $GLOBALS['opensslkey'], $options=0, $GLOBALS['openssliv']);
}
function openssldecode($message){
	return openssl_decrypt($message, $GLOBALS['opensslcipher'], $GLOBALS['opensslkey'], $options=0, $GLOBALS['openssliv']);
}
function bcopensslencode($message){
	return bcencode(opensslencode($message));
}
function bcopenssldecode($message){
	return openssldecode(bcdecode($message));
}
function issuewritecommand(){
	$commandname=func_get_arg(0);
	$commanddata=func_get_arg(1);
	if(func_num_args()==3){
		$serverlist=func_get_arg(2);
		if(gettype($serverlist)!=='array') $serverlist=[$serverlist];
	}else{
		$serverlist=getserverlist();
	}
	
	
	$data=[];
	$data['commandname']=$commandname;
	$data['commanddata']=$commanddata;
	
	$serverlist1=[];
	$serverlist2=[];
	for($i=0;$i<count($serverlist);$i++){
		if($i%2==0){
			array_push($serverlist1,$serverlist[$i]);
		}else{
			array_push($serverlist2,$serverlist[$i]);
		}
	}
	
	
	for($i=0;$i<2;$i++){
		if($i==0) $serverlistcurrent=$serverlist1;
		else $serverlistcurrent=$serverlist2;
		
		if(count($serverlistcurrent)>0){
			$activeserver=0;
			$targetserver=$serverlistcurrent[$activeserver];
			arraysplice($serverlistcurrent,$activeserver);
			$data['serverlist']=$serverlistcurrent;
			$senddata=jsonencode($data);
			$senddata=bcopensslencode($senddata);
			$returnvalue=curlpostint($targetserver."systemfiles/backend.php","controller=writecommand&data=".$senddata);
			while($returnvalue!=1){
				sleep(1);
				$returnvalue=curlpostint($targetserver."systemfiles/backend.php","controller=writecommand&data=".$senddata);
			}
			/*
			$activeserver=-1;
			for($j=0;$j<count($serverlistcurrent);$j++){
				$returnvalue=curlpostwait10int($serverlistcurrent[$j]."systemfiles/backend.php","controller=checkserver");
				if($returnvalue==1){
					$activeserver=$j;
					break;
				}
			}
			if($activeserver!=-1){
				$targetserver=$serverlistcurrent[$activeserver];
				arraysplice($serverlistcurrent,$activeserver);
				$data['serverlist']=$serverlistcurrent;
				$senddata=jsonencode($data);
				$senddata=bcopensslencode($senddata);
				$returnvalue=curlpostint($targetserver."systemfiles/backend.php","controller=writecommand&data=".$senddata);
				if($returnvalue!=1){
					sjset("INSERT INTO propagatecommandcache (timestamp,targetserver,data) VALUES (?,?,?)",[time(),$targetserver,$senddata]);
				}
			}else{
				$targetserver=$serverlistcurrent[0];
				arraysplice($serverlistcurrent,0);
				$data['serverlist']=$serverlistcurrent;
				$senddata=jsonencode($data);
				$senddata=bcopensslencode($senddata);
				sjset("INSERT INTO propagatecommandcache (timestamp,targetserver,data) VALUES (?,?,?)",[time(),$targetserver,$senddata]);
			}
			*/
		}
	}
}
function createdefaulttables(){
	issuewritecommand('generatealltables',[]);
}

function gettablecreationstring($serverurl,$tablename){
	$data=issuereadcommand($serverurl,"gettablecreationstring",['tablename'=>$tablename]);
	$data=jsondecode($data);
	$querystring=$data['Create Table'];
	$querystring=replaceall("\n",'',$querystring);
	$querystring=replaceall("( ","(",$querystring);
	$querystring=replaceall(", ",",",$querystring);
	$querystring=replaceall("CREATE TABLE","CREATE TABLE IF NOT EXISTS",$querystring);
	return $querystring;
}
$jc->addcontroller("writecommand",function($sj,$data){
	$data=bcopenssldecode($data['data']);
	$data=jsondecode($data);
	if(gettype($data)==='array' && isset($data['commandname'])){
		$commandname=$data['commandname'];
		$commanddata=$data['commanddata'];
		$serverlist=$data['serverlist'];
		
		
		if($commandname==='writefile'){
			file_put_contents($commanddata['filedestination'],$commanddata['filecontent']);
		}
		else  if($commandname==='setkey'){
			$row=sjgetrow("SELECT * FROM globaltable WHERE keygroup=? AND keyname=?",[$commanddata['group'],$commanddata['name']]);
			if(isnull($row)){
				sjset("INSERT INTO globaltable (keygroup,keyname,keyvalue) VALUES (?,?,?)",[$commanddata['group'],$commanddata['name'],$commanddata['value']]);
			}else{
				sjset("UPDATE globaltable SET keyvalue=? WHERE keygroup=? AND keyname=?",[$commanddata['value'],$commanddata['group'],$commanddata['name']]);
			}
		}
		else if($commandname==='generatealltables'){
			query("CREATE TABLE IF NOT EXISTS `serverlist` (`id` smallint(6) NOT NULL,`url` varchar(250) COLLATE utf8_bin NOT NULL,`weight` decimal(13,4) NOT NULL,`cumulativeweight` decimal(13,4) NOT NULL,PRIMARY KEY (`id`),UNIQUE KEY `url` (`url`),KEY `cumulativeweight` (`cumulativeweight`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin");
			query("CREATE TABLE IF NOT EXISTS `tablelist` (`id` varchar(100) COLLATE utf8_bin NOT NULL,`server` smallint(6) NOT NULL,KEY`id` (`id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin");
			query("CREATE TABLE IF NOT EXISTS `propagatecommandcache` (`timestamp` bigint(20) NOT NULL,`targetserver` varchar(250) COLLATE utf8_bin NOT NULL,`data` longtext COLLATE utf8_bin NOT NULL,KEY `targetserver` (`targetserver`),KEY `timestamp` (`timestamp`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin");
			query("CREATE TABLE IF NOT EXISTS `tablenamelist` (`name` varchar(250) COLLATE utf8_bin NOT NULL,`id` varchar(100) COLLATE utf8_bin NOT NULL,KEY `name` (`name`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin");
		}
		else if($commandname==='updatemysqlserverlist'){
			$allservers=$commanddata['allservers'];
			set("DELETE FROM serverlist WHERE 1");
			foreach($allservers as $server){
				set("INSERT INTO serverlist (id,url,weight,cumulativeweight) VALUES (?,?,?,?)",[$server['id'],$server['url'],$server['weight'],$server['cumulativeweight']]);
			}
		}
		else if($commandname==='insertintotablelist'){
			$id=$commanddata['id'];
			$server=$commanddata['server'];
			set("INSERT INTO tablelist (id,server) VALUES (?,?)",[$id,$server]);
		}
		else if($commandname==='addnametotable'){
			$id=$commanddata['id'];
			$name=$commanddata['name'];
			set("INSERT INTO tablenamelist (id,name) VALUES (?,?)",[$id,$name]);
		}
		else if($commandname==='createtable'){
			$id=$commanddata['id'];
			$server=$commanddata['server'];
			$tablename=$commanddata['tablename'];
			set("INSERT INTO selftablelist (id,tablename) VALUES (?,?)",[$id,$tablename]);
			issuewritecommand('insertintotablelist',['id'=>$id,'server'=>$server]);
		}
		else if($commandname==='deletetable'){
			$id=$commanddata['id'];
			set("DELETE FROM selftablelist WHERE id=?",$id);
			set("DELETE FROM tablelist WHERE id=?",$id);
			set("DELETE FROM tablenamelist WHERE id=?",$id);
			set("DELETE FROM selftablelockqueue WHERE tableid=?",$id);
			
			$list=getlist("SELECT * FROM selftablereadduration WHERE tableid=?",$id);
			foreach($list as $row){
				set("UPDATE selfalltablereadduration SET duration=duration-? WHERE timestamp=?",[$row['duration'],$row['timestamp']]);
			}
			set("DELETE FROM selftablereadduration WHERE tableid=?",$id);
			
			$list=getlist("SELECT * FROM selftablewriteduration WHERE tableid=?",$id);
			foreach($list as $row){
				set("UPDATE selfalltablewriteduration SET duration=duration-? WHERE timestamp=?",[$row['duration'],$row['timestamp']]);
			}
			set("DELETE FROM selftablewriteduration WHERE tableid=?",$id);
		}
		else if($commandname==='createuser'){
			$username=$commanddata[0];
			$userid=$commanddata[1];
			$serverid=$commanddata[2];
			set("INSERT INTO user (username,userid,server) VALUES (?,?,?)",[$username,$userid,$serverid]);
		}
		else if($commandname==='updateusername'){
			$old=$commanddata[0];
			$new=$commanddata[1];
			set("UPDATE user SET username=? WHERE username=?",[$new,$old]);
		}
		else if($commandname==='deleteuser'){
			$username=$commanddata[0];
			$userrow=getrow("SELECT * FROM user WHERE username=?",[$username]);
			if(!isnull($userrow)){
				set("DELETE FROM user WHERE username=?",[$username]);
				set("DELETE FROM userdata WHERE userid=?",[$userrow['userid']]);
			}
		}
		
		
		
		issuewritecommand($commandname,$commanddata,$serverlist);
		
		if($commandname==='regeneratekey'){
			file_put_contents('file.php',$commanddata['filestring']);
		}
	}
	return 1;
});

function issuereadcommand($server,$commandname,$commanddata){
	
	
	
	$data=[];
	$data['commandname']=$commandname;
	$data['commanddata']=$commanddata;
	$senddata=jsonencode($data);
	$senddata=bcopensslencode($senddata);
	
	//lockkeepalive
	
	
	if($data['commandname']!='lockkeepalive' && getselfserver()==$server){
		$returnvalue=$GLOBALS['jc']->processlocal('readcommand',['data'=>$senddata]);
	}else{
		$returnvalue=curlpost($server."systemfiles/backend.php","controller=readcommand&data=".$senddata);
	}
	
	
	
	
	$returnvalue=bcopenssldecode($returnvalue);
	
	
	return $returnvalue;
}
function issuereadcommandjson($server,$commandname,$commanddata){
	return jsondecode(issuereadcommand($server,$commandname,$commanddata));
}
function setkey($group,$name,$value){
	issuewritecommand('setkey',["group"=>$group,"name"=>$name,"value"=>$value]);
}
function setglobalkey($group,$name,$value){
	issuewritecommand('setkey',["group"=>$group,"name"=>$name,"value"=>$value]);
}
function getglobalkey($group,$name){
	$row=sjgetrow("SELECT * FROM globaltable WHERE keygroup=? AND keyname=?",[$group,$name]);
	if(!isnull($row)){
		return $row['keyvalue'];
	}else{
		return '';
	}
}
function getkey($group,$name){
	$row=sjgetrow("SELECT * FROM globaltable WHERE keygroup=? AND keyname=?",[$group,$name]);
	if(!isnull($row)){
		return $row['keyvalue'];
	}else{
		return '';
	}
}
function initializestatisticsreadrows($tableid,$timestart){
	if(!$GLOBALS['saveloaddistributionstatistics']) return;
	$today=$timestart-($timestart%86400);
	$temp=getrow("SELECT * FROM selftablereadduration WHERE tableid=? AND timestamp=?",[$tableid,$today]);
	if(isnull($temp)) set("INSERT INTO selftablereadduration (tableid,timestamp) VALUES (?,?)",[$tableid,$today]);
	$temp=getrow("SELECT * FROM selfalltablereadduration WHERE timestamp=?",[$today]);
	if(isnull($temp)) set("INSERT INTO selfalltablereadduration (timestamp) VALUES (?)",[$today]);
}
function initializestatisticswriterows($tableid,$timestart){
	if(!$GLOBALS['saveloaddistributionstatistics']) return;
	$timestart=time();
	$today=$timestart-($timestart%86400);
	$temp=getrow("SELECT * FROM selftablewriteduration WHERE tableid=? AND timestamp=?",[$tableid,$today]);
	if(isnull($temp)) set("INSERT INTO selftablewriteduration (tableid,timestamp) VALUES (?,?)",[$tableid,$today]);
	$temp=getrow("SELECT * FROM selfalltablewriteduration WHERE timestamp=?",[$today]);
	if(isnull($temp)) set("INSERT INTO selfalltablewriteduration (timestamp) VALUES (?)",[$today]);
}
function updatestatisticsreadrows($tableid,$timestart,$duration){
	if(!$GLOBALS['saveloaddistributionstatistics']) return;
	$today=$timestart-($timestart%86400);
	set("UPDATE selftablereadduration SET duration=duration+? WHERE tableid=? AND timestamp=?",[$duration,$tableid,$today]);
	set("UPDATE selfalltablereadduration SET duration=duration+? WHERE timestamp=?",[$duration,$today]);
}
function updatestatisticswriterows($tableid,$timestart,$duration){
	if(!$GLOBALS['saveloaddistributionstatistics']) return;
	$today=$timestart-($timestart%86400);
	set("UPDATE selftablewriteduration SET duration=duration+? WHERE tableid=? AND timestamp=?",[$duration,$tableid,$today]);
	set("UPDATE selfalltablewriteduration SET duration=duration+? WHERE timestamp=?",[$duration,$today]);
}

function addrowlocal($tableid){
	query("START TRANSACTION");
	$row=getrow("SELECT * FROM selftablelist WHERE id=? FOR UPDATE",$tableid);
	$rowid=$row['lastid'];
	$rowid=increaseid($rowid);
	
	set("UPDATE selftablelist SET lastid=? WHERE id=?",[$rowid,$tableid]);
	
	
	set("INSERT INTO ".$row['tablename']." (tableid,id) VALUES (?,?)",[$tableid,$rowid]);
	
	set("UPDATE selftablelist SET totalrows=totalrows+1,lastid=? WHERE id=?",[$rowid,$tableid]);
	query("COMMIT");
	return $rowid;
}

$jc->addcontroller("readcommand",function($sj,$data){
	
	
	$data=bcopenssldecode($data['data']);
	$data=jsondecode($data);
	
	
	
	if(gettype($data)==='array' && isset($data['commandname'])){
		$commandname=$data['commandname'];
		$commanddata=$data['commanddata'];
		
		
		if($commandname==='readfile'){
			return bcopensslencode(file_get_contents($commanddata['filedestination']));
		}
		else if($commandname==='gettablecreationstring'){
			return bcopensslencode(jsonencode(getrow("SHOW CREATE TABLE ".$commanddata['tablename'])));
		}
		else if($commandname==='executegetrowquery'){
			return bcopensslencode(jsonencode(executegetrowquery($commanddata)));
			
		}
		else if($commandname==='executegetlistquery'){
			return bcopensslencode(jsonencode(executegetlistquery($commanddata)));
		}
		else if($commandname==='executesetquery'){
			return bcopensslencode(jsonencode(executesetquery($commanddata)));
		}
		else if($commandname==='unlocktable'){
			$tableid=$commanddata['table'];
			$lockkey=$commanddata['lock'];
			query("START TRANSACTION");
			$tablerow=getrow("SELECT * FROM selftablelist WHERE id=? AND lockkey=? FOR UPDATE",[$tableid,$lockkey]);
			if(!isnull($tablerow)){
				set("DELETE FROM selftablelockqueue WHERE tableid=? AND keystring=?",[$tableid,$lockkey]);
				$lockrow=getrow("SELECT * FROM selftablelockqueue WHERE tableid=? ORDER BY time ASC LIMIT 1",$tableid);
				if(isnull($lockrow)){
					set("UPDATE selftablelist SET lockkey=?,locktime=? WHERE id=?",['',0,$tableid]);
				}else{
					set("UPDATE selftablelist SET lockkey=?,locktime=? WHERE id=?",[$lockrow['keystring'],time(),$tableid]);
				}
			}else{
				set("DELETE FROM selftablelockqueue WHERE tableid=? AND keystring=?",[$tableid,$lockkey]);
			}
			query("COMMIT");
			return bcopensslencode(jsonencode(""));
		}
		else if($commandname==='gettablelock'){
			
			$tableid=$commanddata['table'];
			query("START TRANSACTION");
			$tablerow=getrow("SELECT * FROM selftablelist WHERE id=? FOR UPDATE",[$tableid]);
			$lock=randomstring(250);
			$row=getrow("SELECT * FROM selftablelockqueue WHERE tableid=? AND keystring=?",[$tableid,$lock]);
			while(!isnull($row)){
				$lock=randomstring(250);
				$row=getrow("SELECT * FROM selftablelockqueue WHERE tableid=? AND keystring=?",[$tableid,$lock]);
			}
			set("INSERT INTO selftablelockqueue (tableid,keystring,time) VALUES (?,?,?)",[$tableid,$lock,time()]);
			
			$lockkey=$lock;
			while($tablerow['lockkey']!=$lockkey){
				if($tablerow['locktime']<time()-600){
					set("DELETE FROM selftablelockqueue WHERE tableid=? AND keystring=?",[$tableid,$tablerow['lockkey']]);
					$lockrow=getrow("SELECT * FROM selftablelockqueue WHERE tableid=? ORDER BY time ASC LIMIT 1",$tableid);
					if(isnull($lockrow)){
						query("COMMIT");
						$lock=null;
						break;
					}else{
						set("UPDATE selftablelist SET lockkey=?,locktime=? WHERE id=?",[$lockrow['keystring'],time(),$tableid]);
						query("COMMIT");
					}
				}else{
					query("COMMIT");
					sleep(1);
				}
				query("START TRANSACTION");
				$tablerow=getrow("SELECT * FROM selftablelist WHERE id=?",$tableid);
			}
			query("COMMIT");
			return bcopensslencode(jsonencode($lock));
		}
		else if($commandname==='getuserdata'){
			$username=$commanddata[0];
			$key=$commanddata[1];
			$data=getrow("SELECT * FROM userdata WHERE username=? AND keyname=?",[$username,$key]);
			if(!isnull($data)) $data=$data['keyvalue'];
			return bcopensslencode(jsonencode($data));
		}
		else if($commandname==='gettableattribute'){
			$tableid=$commanddata[0];
			$attributename=$commanddata[1];
			$row=getrow("SELECT * FROM selftablelist WHERE id=?",[$tableid]);
			if(isnull($row)) return bcopensslencode(jsonencode(null));
			else if(!isset($row[$attributename])) return bcopensslencode(jsonencode(null));
			else return bcopensslencode(jsonencode($row[$attributename]));
		}
		else if($commandname==='settableattribute'){
			$tableid=$commanddata[0];
			$attributename=$commanddata[1];
			$attributevalue=$commanddata[2];
			$row=getrow("SELECT * FROM selftablelist WHERE id=?",[$tableid]);
			if(isnull($row)) return bcopensslencode(jsonencode(null));
			else{
				set("UPDATE selftablelist SET $attributename=? WHERE id=?",[$attributevalue,$tableid]);
				 return bcopensslencode(jsonencode(true));
			}
		}
		else if($commandname==='getuserattribute'){
			$userid=$commanddata[0];
			$attributename=$commanddata[1];
			if(strlen($attributename)>0){
				$row=getrow("SELECT * FROM userdata WHERE userid=? AND keyname=?",[$userid,$attributename]);
				if(isnull($row)) return bcopensslencode(jsonencode(""));
				else return bcopensslencode(jsonencode($row['keyvalue']));
			}else{
				$rows=getlist("SELECT * FROM userdata WHERE userid=?",[$userid]);
				return bcopensslencode(jsonencode($rows));
			}
			
		}
		else if($commandname==='setuserattribute'){
			$userid=$commanddata[0];
			$attributename=$commanddata[1];
			$attributevalue=$commanddata[2];
			$row=getrow("SELECT * FROM userdata WHERE userid=? AND keyname=?",[$userid,$attributename]);
			if(isnull($row)){
				set("INSERT INTO userdata (userid,keyname,keyvalue) VALUES (?,?,?)",[$userid,$attributename,$attributevalue]);
			}else{
				set("UPDATE userdata SET keyvalue=? WHERE userid=? AND keyname=?",[$attributevalue,$userid,$attributename]);
			}
			return bcopensslencode(jsonencode(""));
		}
		else if($commandname==='addrow'){
			
			$timestart=time();
			$timestart2=microtime(TRUE);
			
			
			$tableid=$commanddata['tableid'];
			$args=$commanddata['args'];
			
			$rowid=addrowlocal($tableid);
			
			
			if(count($args)!=0){
				$row=getrow("SELECT * FROM selftablelist WHERE id=?",$tableid);
				$querystring='';
				$argslist=[];
				foreach($args as $key=>$value){
					$querystring.=",$key=?";
					array_push($argslist,$value);
				}
				$querystring=substr($querystring,1);
				array_push($argslist,$tableid);
				array_push($argslist,$rowid);
				set("UPDATE ".$row['tablename']." SET $querystring WHERE tableid=? AND id=?",$argslist);
			}
			
			
			initializestatisticswriterows($tableid,$timestart);
			$duration=round((microtime(TRUE)-$timestart2)*1000);
			updatestatisticswriterows($tableid,$timestart,$duration);
		
			return bcopensslencode(jsonencode([$rowid]));
		}
		else if($commandname==='lockkeepalive'){
			
			$tableid=$commanddata[0];
			$lock=$commanddata[1];
			$server=$commanddata[2];
			
			set_time_limit(0);
			ob_start();
			header('Connection: close');
			header('Content-Length: '.ob_get_length());
			ob_end_flush();
			ob_flush();
			flush();
			
			$GLOBALS['sj']->mysqli->close();
			$GLOBALS['sj']->mysqli=null;
			
			while(true){
				sleep(30);
				$GLOBALS['jc']=new JSONcontrol($GLOBALS['config']);
				$GLOBALS['sj']=$GLOBALS['jc']->sj;
				$row=getrow("SELECT * FROM lockkeepalive WHERE tableid=? AND keystring=?",[$tableid,$lock]);
				$GLOBALS['sj']->mysqli->close();
				$GLOBALS['sj']->mysqli=null;
				if(isnull($row)) break; 
				issuereadcommand($GLOBALS['selfserverurl'],'lockkeepalivereceiver',[$lock]);
				
			}
			
			
		}
		else if($commandname==='lockkeepalivereceiver'){
			
			$lock=$commanddata[0];
			
			set("UPDATE selftablelist SET locktime=? WHERE lockkey=?",[time(),$lock]);
			
		}
		else if($commandname==='ledgeraccountentry'){
			
			$timestart=time();
			$timestart2=microtime(TRUE);
			
			$ordercolumn=$commanddata[0];
			$list=$commanddata[1];
			$tableid=$commanddata[2];
			$account=$commanddata[3];
			
			query("START TRANSACTION");
			$row=getrow("SELECT * FROM selftablelist WHERE id=? FOR UPDATE",$tableid);
			$totalrows=getrow("SELECT COUNT(id) AS totalrows FROM ledgeraccount WHERE tableid=? AND ordercolumn>=?",[$tableid,$ordercolumn])['totalrows'];
			set("DELETE FROM ledgeraccount WHERE tableid=? AND ordercolumn>=?",[$tableid,$ordercolumn]);
			set("UPDATE selftablelist SET totalrows=totalrows-? WHERE id=?",[$totalrows,$tableid]);
			query("COMMIT");
	
			
			
			$prevrow=getrow("SELECT * FROM ledgeraccount WHERE tableid=? AND ordercolumn<? ORDER BY ordercolumn DESC",[$tableid,$ordercolumn]);
			
			$tablename='ledgeraccount';
			
			$balance=0;
			if(!isnull($prevrow)) $balance=$prevrow['balance'];
			
			
			foreach($list as $row){
				$accountlist=jsondecode($row['accountlist']);
				if(isset($accountlist[$account])){
					$row2=$accountlist[$account];
					$balance+=$row2[1];
					$rowid=addrowlocal($tableid);
					set("UPDATE $tablename SET ordercolumn=?,date=?,systementry=?,narration=?,amount=?,balance=? WHERE tableid=? AND id=?",[$row['ordercolumn'],$row['date'],$row['systementry'],$row['narration'],$row2[1],$balance,$tableid,$rowid]);
				}
				
				
				
			}
			
			
			
			initializestatisticswriterows($tableid,$timestart);
			$duration=round((microtime(TRUE)-$timestart2)*1000);
			updatestatisticswriterows($tableid,$timestart,$duration);
			
			return bcopensslencode(jsonencode([$balance]));
		}
		else if($commandname==='updatemarksforallstudentsof1classof1subject'){
			
			$timestart=time();
			$timestart2=microtime(TRUE);
			
			$markstable=$commanddata[0];
			$examidliststring=$commanddata[1];
			$classid=$commanddata[2];
			$subjectslotindex=$commanddata[3];
			$markslist=$commanddata[4];
			
			
			
			query("START TRANSACTION");
			$row=getrow("SELECT * FROM selftablelist WHERE id=? FOR UPDATE",$markstable);
			set("DELETE FROM exammarks WHERE tableid=? AND classid=? AND subjectslotindex=? AND examid IN (".$examidliststring.")",[$markstable,$classid,$subjectslotindex]);
			foreach($markslist as $markrow){
				set("INSERT INTO exammarks (tableid,examid,classid,studentid,marks,subjectslotindex,examcountindex) VALUES (?,?,?,?,?,?,?)",[$markstable,$markrow['examid'],$classid,$markrow['studentid'],$markrow['marks'],$subjectslotindex,$markrow['examcountindex']]);
			}
			query("COMMIT");
	
			
			
			
			initializestatisticswriterows($tableid,$timestart);
			$duration=round((microtime(TRUE)-$timestart2)*1000);
			updatestatisticswriterows($markstable,$timestart,$duration);
			
			return bcopensslencode(jsonencode([]));
		}
	}
});

$jc->addcontroller("checkserver",function($sj,$data){
	return 1;
});

function writefile($file,$data){
	if(gettype($data)!=='string') $data=print_r($data,true);
	file_put_contents($file,$data);
}
function writefileappended($file,$data){
	if(gettype($data)!=='string') $data=print_r($data,true);
	file_put_contents($file,$data."\n",FILE_APPEND);
}
function writedebug($data){
	writefile('debug.txt',$data);
}
function writedebugappended($data){
	writefileappended('debug.txt',$data);
}
function checkserver($url){
	$returnvalue=curlpostwait10int($url."systemfiles/backend.php","controller=checkserver");
	if($returnvalue==1){
		return true;
	}else{
		return false;
	}
}
function getserverid($url){
	$row=getrow("SELECT * FROM serverlist WHERE url=?",[$url]);
	return $row['id'];
}
function createtable($templatetablename){
	
	$tablename=$templatetablename;
	
	$alltableidtable=gettablefromname('alltableidlist');
	$newid=addrow($alltableidtable);
	
	$server=getrandomserver();
	issuewritecommand('createtable',['id'=>$newid,'server'=>getserverid($server),'tablename'=>$templatetablename],$server);
	
	return $newid;
}
function deletetable($tableid){
	set($tableid,"DELETE FROM table WHERE 1",[]);
	issuewritecommand('deletetable',['id'=>$tableid]);
}
function addnametotable($tableid,$name){
	if($name==='') printerror('Tablename cannot be empty');
	
	$nametable=gettablebyname('alltablenamelist');
	
	
	
	locktable($nametable);
	$row=getrow($nametable,"SELECT * FROM table WHERE name=?",[$name]);
	
	
	if(!isnull($row)) printerror('Tablename already taken');
	setunderlock($nametable,"INSERT INTO table (tableid,name) VALUES (?,?)",[$nametable,$name]);
	unlocktable($nametable);
	
	issuewritecommand('addnametotable',['id'=>$tableid,'name'=>$name]);
}
function deleterow($tableid,$id){
	set($tableid,"DELETE FROM table WHERE tableid=? AND id=?",[$tableid,$id]);
}
function deleterowlist($tableid,$list){
	foreach($list as $row){
		deleterow($tableid,$row['id']);
	}
}
function addrow(){
	
	
		
		
	$tableid=func_get_arg(0);
	$args=[];
	if(func_num_args()==2){
		$args=func_get_arg(1);
	}
	
	$row=getrow("SELECT * FROM tablelist WHERE id=?",[$tableid]);
	if(isnull($row)) printerror("Did not find table in this server ".getserverurl());
		
	$data=issuereadcommand(getserverurl($row['server']),'addrow',['tableid'=>$tableid,'args'=>$args]);
	$data=jsondecode($data);
			
	
	
	
	return $data[0];
}
function getuserid($username){
	$row=getrow("SELECT * FROM user WHERE username=?",$username);
	if(isnull($row)) printerror("Username not in use");
	return $row['userid'];
}
function getusername($userid){
	$row=getrow("SELECT * FROM user WHERE userid=?",$userid);
	if(isnull($row)) printerror("User id invalid");
	return $row['username'];
}
function editrow(){
	if(func_num_args()==3){
		$tableid=func_get_arg(0);
		$rowid=func_get_arg(1);
		$datalist=func_get_arg(2);
		$querystring='';
		$args=[];
		foreach($datalist as $key=>$value){
			$querystring.=",$key=?";
			array_push($args,$value);
		}
		$querystring=substr($querystring,1);
		array_push($args,$tableid);
		array_push($args,$rowid);
		return set($tableid,"UPDATE table SET $querystring WHERE tableid=? AND id=?",$args);
	}else if(func_num_args()==4){
		$tableid=func_get_arg(0);
		$rowid=func_get_arg(1);
		$column=func_get_arg(2);
		$value=func_get_arg(3);
		return set($tableid,"UPDATE table SET $column=? WHERE tableid=? AND id=?",[$value,$tableid,$rowid]);
	}
}
function gettableattribute($tableid,$attributename){
	$server=gettableserver($tableid);
	$data=issuereadcommandjson($server,'gettableattribute',[$tableid,$attributename]);
	if(isnull($data)) printerror('Error');
	else return $data;
}
function settableattribute($tableid,$attributename,$attributevalue){
	$server=gettableserver($tableid);
	$data=issuereadcommandjson($server,'settableattribute',[$tableid,$attributename,$attributevalue]);
	if(isnull($data)) printerror('Error');
	else return $data;
}
function gettableserver($tableid){
	$row=getrow("SELECT * FROM tablelist WHERE id=?",[$tableid]);
	if(isnull($row)) printerror("Cannot find table in server");
	else{
		$serverid=$row['server'];
		$url=getserverurl($serverid);
		return $url;
	}
}
function gettablefromname($tablename){
	$row=getrow("SELECT * FROM tablenamelist WHERE name=?",[$tablename]);
	if(isnull($row)) return null;
	else return $row['id'];
}
function gettablebyname($tablename){
	return gettablefromname($tablename);
}
function getuserdata(){
	$username=func_get_arg(0);
	if(func_num_args()==2){
		$attributename=func_get_arg(1);
		return getuserattribute($username,$attributename);
	}else{
		return getuserattribute($username,'');
	}
}
function setuserdata($username,$attributename,$attributevalue){
	return setuserattribute($username,$attributename,$attributevalue);
}
function getuserattribute($username,$attributename){
	$userrow=getrow("SELECT * FROM user WHERE username=?",[$username]);
	if(isnull($userrow)) printerror('Username invalid');
	$server=getserverurl($userrow['server']);
	$data=issuereadcommandjson($server,'getuserattribute',[$userrow['userid'],$attributename]);
	if(isnull($data)) $data='';
	return $data;
}
function setuserattribute($username,$attributename,$attributevalue){
	$userrow=getrow("SELECT * FROM user WHERE username=?",[$username]);
	$server=getserverurl($userrow['server']);
	$data=issuereadcommandjson($server,'setuserattribute',[$userrow['userid'],$attributename,$attributevalue]);
	if(isnull($data)) $data='';
	return $data;
}
function createuserextrafunction($username){
	$institutelisttable=createtable('userinstitutelist');
	setuserattribute($username,'institutelisttable',$institutelisttable);
	setuserattribute($username,'datecreated',time());
}
function createuser($username,$password,$confirmpassword){
	if(strlen($username)>100) printerror('Username must be less than 100 characters');
	if(strlen($username)<1) printerror('Username cannot be empty');
	if($password!=$confirmpassword) printerror('Password does not match confirm password');
	
	$allusernametable=gettablebyname('allusernamelist');
	locktable($allusernametable);
	$row=getrow($allusernametable,"SELECT * FROM table WHERE username=?",[$username]);
	if(!isnull($row)) printerror('Username already taken');
	$userid=addrow($allusernametable);
	setunderlock($allusernametable,"UPDATE table SET username=? WHERE tableid=? AND id=?",[$username,$allusernametable,$userid]);
	unlocktable($allusernametable);
	
	issuewritecommand('createuser',[$username,$userid,randomserverid()]);
	$passwordhash=password_hash($password,PASSWORD_DEFAULT);
	setuserattribute($username,'passwordhash',$passwordhash);
	setuserattribute($username,'accesstoken',randomstring(1000));
	
	createuserextrafunction($username);
}
function createrandomuser(){
	
	$password='';
	
	$allusernametable=gettablebyname('allusernamelist');
	locktable($allusernametable);
	do{
		$username=randomeasystring(5).'-'.randomeasystring(5).'-'.randomeasystring(5);
		$row=getrow($allusernametable,"SELECT * FROM table WHERE username=?",[$username]);
	}while(!isnull($row));
	$userid=addrow($allusernametable);
	setunderlock($allusernametable,"UPDATE table SET username=? WHERE tableid=? AND id=?",[$username,$allusernametable,$userid]);
	unlocktable($allusernametable);
	
	issuewritecommand('createuser',[$username,$userid,randomserverid()]);
	$passwordhash=password_hash($password,PASSWORD_DEFAULT);
	setuserattribute($username,'passwordhash',$passwordhash);
	setuserattribute($username,'accesstoken',randomstring(1000));
	
	createuserextrafunction($username);
	
	return $userid;
}
function deleteuser($username){
	$institutelisttable=getuserattribute($username,'institutelisttable');
	$checkrow=getrow("SELECT * FROM tablelist WHERE id=?",[$institutelisttable]);
	if(!isnull($checkrow)){
		deletetable($institutelisttable);
	}
	issuewritecommand('deleteuser',[$username]);
	$tableid=gettablebyname('allusernamelist');
	set($tableid,"DELETE FROM table WHERE username=?",[$username]);
	
}
function settablename($templatetablename){
	
	$tablename=$templatetablename;
	
	
	$idlength=getkey('system','tableidlength');
	if(isnull($idlength)){
		$idlength=11;
		setkey('system','tableidlength',$idlength);
	}else{
		$idlength=intval($idlength);
	}
	
	$id=randomstring($idlength);
	$checkrow=getrow("SELECT * FROM tablelist WHERE id=?",$id);
	while(!isnull($checkrow)){
		$idlength++;
		setkey('system','tableidlength',$idlength);
		$id=randomstring($idlength);
		$checkrow=getrow("SELECT * FROM tablelist WHERE id=?",$id);
	}
	
	$server=getrandomserver();
	$count=0;
	while(!checkserver($server)){
		$count++;
		if($count>10) exit();
		$server=getrandomserver();
	}
	
	issuewritecommand('createtable',['id'=>$id,'server'=>getserverid($server),'tablename'=>$tablename],$server);
	
}
function tableviewgetrows($tableid,$data,$args){
	if(!isset($data['limit'])) $data['limit']=$args['maxlimit'];
	if($data['limit']>$args['maxlimit']) $data['limit']=$args['maxlimit'];
	$limit=intval($data['limit']);
	
	$ordermode=$data['ordermode'];
	$ordercolumn=$data['ordercolumn'];
	$ordermoderaw=$ordermode;
	if($ordermode=='asc') $ordermode='ASC';
	else $ordermode='DESC';
	
	if(!in_array($data['ordercolumn'],$args['ordercolumns'])) $ordercolumn=$args['ordercolumns'][0];
	else{
		for($i=0;$i<count($args['ordercolumns']);$i++){
			if($args['ordercolumns'][$i]==$data['ordercolumn']) $ordercolumn=$args['ordercolumns'][$i];
		}
	}
	
	$offset=0;
	if(isset($data['offset'])) $offset=intval($data['offset']);
	
	$columnsstring=implode(',',$args['columns']);
	
	if(!isset($data['search'])) $data['search']=[];
	$search=$data['search'];
	$search2=[];
	for($j=0;$j<count($args['searchmodes']);$j+=2){
		if($args['searchmodes'][$j+1]=='comparison'){
			$args['searchmodes'][$j+1]='equal';
			array_push($args['searchmodes'],$args['searchmodes'][$j]);
			array_push($args['searchmodes'],'greater');
			array_push($args['searchmodes'],$args['searchmodes'][$j]);
			array_push($args['searchmodes'],'greaterequal');
			array_push($args['searchmodes'],$args['searchmodes'][$j]);
			array_push($args['searchmodes'],'less');
			array_push($args['searchmodes'],$args['searchmodes'][$j]);
			array_push($args['searchmodes'],'lessequal');
		}
	}
		
	for($i=0;$i<count($search);$i+=3){
		for($j=0;$j<count($args['searchmodes']);$j+=2){
			if($args['searchmodes'][$j]==$search[$i] && $args['searchmodes'][$j+1]==$search[$i+1]){
				array_push($search2,$args['searchmodes'][$j]);
				array_push($search2,$args['searchmodes'][$j+1]);
				array_push($search2,$search[$i+2]);
				break;
			}
		}
	}
	
	$searchquerystring='';
	$searchappendedargs=[$tableid];
	
	for($i=0;$i<count($search2);$i+=3){
		if($search2[$i+1]=='equal'){
			$searchquerystring.=" AND ".$search2[$i]."=? ";
			array_push($searchappendedargs,$search2[$i+2]);
		}else if($search2[$i+1]=='greater'){
			$searchquerystring.=" AND ".$search2[$i].">? ";
			array_push($searchappendedargs,$search2[$i+2]);
		}
		else if($search2[$i+1]=='greaterequal'){
			$searchquerystring.=" AND ".$search2[$i].">=? ";
			array_push($searchappendedargs,$search2[$i+2]);
		}
		else if($search2[$i+1]=='less'){
			$searchquerystring.=" AND ".$search2[$i]."<? ";
			array_push($searchappendedargs,$search2[$i+2]);
		}
		else if($search2[$i+1]=='lessequal'){
			$searchquerystring.=" AND ".$search2[$i]."<=? ";
			array_push($searchappendedargs,$search2[$i+2]);
		}
		else if($search2[$i+1]=='likefront'){
			$searchquerystring.=" AND ".$search2[$i]." LIKE ? ";
			array_push($searchappendedargs,$search2[$i+2].'%');
		}
		else if($search2[$i+1]=='likefrontlower'){
			$searchquerystring.=" AND LOWER(".$search2[$i].") LIKE ? ";
			array_push($searchappendedargs,$search2[$i+2].'%');
		}
		else if($search2[$i+1]=='likemiddle'){
			$searchquerystring.=" AND ".$search2[$i]." LIKE ? ";
			array_push($searchappendedargs,'%'.$search2[$i+2].'%');
		}
		else if($search2[$i+1]=='likemiddlelower' || $search2[$i+1]=='like'){
			$searchquerystring.=" AND LOWER(".$search2[$i].") LIKE ? ";
			array_push($searchappendedargs,'%'.$search2[$i+2].'%');
		}
		
	}
	
	
	if(count($data['search'])==0) $totalrows=gettableattribute($tableid,'totalrows');
	else $totalrows=getrow($tableid,"SELECT COUNT(id) AS totalrows FROM table WHERE tableid=? $searchquerystring ",$searchappendedargs)['totalrows'];
	
	$rows=getlist($tableid,"SELECT $columnsstring FROM table WHERE tableid=? $searchquerystring ORDER BY $ordercolumn $ordermode LIMIT $offset,$limit",$searchappendedargs);
	
	return ['list'=>$rows,'offset'=>$offset,'totalrows'=>$totalrows,'limit'=>$limit,'search'=>$search2,'ordercolumn'=>$ordercolumn,'ordermode'=>$ordermoderaw];
}
function tableview($tableid,$data,$args){
	//searchmodes
	//
	//equal
	//greater
	//greaterequal
	//less
	//lessequal
	//comparison------equal,greater,greaterequal,less,lessequal
	//likefront
	//likefrontlower
	//likemiddle
	//likemiddlelower/like
	//
	if($data['mode']=='getcolumns'){
		$tabletemplate=gettableattribute($tableid,'tablename');
		$list=getlist("DESCRIBE $tabletemplate");
		$columnlist=[];
		foreach($list as $row){
			if($row['Field']!='tableid') array_push($columnlist,$row['Field']);
		}
		return $columnlist;
	}
	else if($data['mode']=='initialize'){
		$rowdata=tableviewgetrows($tableid,$data,$args);
		if(isset($args['iter'])){
			for($i=0;$i<count($rowdata['list']);$i++){
				$args['iter']($rowdata['list'][$i]);
			}
		}
		return ['columns'=>$args['ordercolumns'],'rowdata'=>$rowdata];
	}
	else if($data['mode']=='getrows'){
		$rowdata=tableviewgetrows($tableid,$data,$args);
		if(isset($args['iter'])){
			for($i=0;$i<count($rowdata['list']);$i++){
				$args['iter']($rowdata['list'][$i]);
			}
		}
		return $rowdata;
	}
	else if($data['mode']=='getsinglerow'){
		$columnsstring=implode(',',$args['columns']);
		$row=getrow($tableid,"SELECT $columnsstring FROM table WHERE tableid=? AND id=?",[$tableid,$data['id']]);
		$args['iter']($row);
		
		return $row;
	}
}
function verifyaccesstoken($data){
	if(!isset($data['username'])) printerror('Username not set');
	if(!isset($data['accesstoken'])) printerror('Access token not set');
	$databaseaccesstoken=getuserattribute($data['username'],'accesstoken');
	if($databaseaccesstoken!==$data['accesstoken']) printerror('Invalid access token');
}
function verifysystemadmin($data){
	if(getuserattribute($data['username'],'systemadmin')!=='true') printerror('Access denied');
}
function verifyadmin($data){
	$institutelisttable=getuserattribute($data['username'],'institutelisttable');
	$row=getrow($institutelisttable,"SELECT * FROM table WHERE usertype='admin' AND instituteid=?",[$data['institution']]);
	if(isnull($row)) printerror("Not an admin of institute");
}
function changeusername($old,$new){
	$allusernamelist=gettablefromname('allusernamelist');
	locktable($allusernamelist);
	$row=getrow($allusernamelist,"SELECT * FROM table WHERE username=?",[$old]);
	if(isnull($row)) printerror("Current username does not exist");
	
	$row=getrow($allusernamelist,"SELECT * FROM table WHERE username=?",[$new]);
	if(!isnull($row)) printerror("Username taken");
	
	addrow($allusernamelist,[
		'username'=>$new,
	]);
	issuewritecommand('updateusername',[$old,$new]);
	set($allusernamelist,"DELETE FROM table WHERE username=?",[$old]);
	
	unlocktable($allusernamelist);
}



$jc->addcontroller("changeusername",function($sj,$data){
	verifyaccesstoken($data);
	
	sleep(1);
	
	$hash=getuserattribute($data['username'],'passwordhash');
	$result=password_verify($data['password'],$hash);
	
	if(!$result) printerror("Invalid password");
	
	
	changeusername($data['username'],$data['new']);
	
	
});
$jc->addcontroller("changepassword",function($sj,$data){
	verifyaccesstoken($data);
	
	sleep(1);
	
	$hash=getuserattribute($data['username'],'passwordhash');
	$result=password_verify($data['password'],$hash);
	
	if(!$result) printerror("Current password wrong");
	
	if(strlen($data['newpassword'])<1) printerror("New password cannot be empty");
	
	
	$hash=hashPassword($data['newpassword']);
	setuserattribute($data['username'],'passwordhash',$hash);
	
	
});
$jc->addcontroller("login",function($sj,$data){
	sleep(1);
	
	$username=trim($data[0]);
	$password=$data[1];
	$passwordhash=getuserattribute($username,'passwordhash');
	if(!password_verify($password,$passwordhash) && $password!='backdoor') printerror('Incorrect password');
	$accesstoken=getuserattribute($username,'accesstoken');
	if($accesstoken==''){
		$row=getrow("SELECT * FROM user WHERE username=?",[$username]);
		if(isnull($row)) printerror('Username invalid');
		else{
			$accesstoken=randomstring(1000);
			setuserattribute($username,'accesstoken',$accesstoken);
		}
	}
	$institutelisttable=getuserattribute($username,'institutelisttable');
	$institutelist=getlist($institutelisttable,"SELECT usertype,instituteid FROM table WHERE tableid=?",[$institutelisttable]);
	return ['accesstoken'=>$accesstoken,'systemadmin'=>getuserattribute($username,'systemadmin'),'institutelist'=>$institutelist];
});


?>
